/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.RegistryMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.res.StringManager;

public class Registry
implements RegistryMBean,
MBeanRegistration {
    private static final Log log = LogFactory.getLog(Registry.class);
    private static final StringManager sm = StringManager.getManager(Registry.class);
    private static HashMap<Object, Registry> perLoaderRegistries = null;
    private static Registry registry = null;
    private MBeanServer server = null;
    private HashMap<String, ManagedBean> descriptors = new HashMap();
    private HashMap<String, ManagedBean> descriptorsByClass = new HashMap();
    private HashMap<String, URL> searchedPaths = new HashMap();
    private Object guard;
    private Hashtable<String, Hashtable<String, Integer>> idDomains = new Hashtable();
    private Hashtable<String, int[]> ids = new Hashtable();

    public static synchronized Registry getRegistry(Object key, Object guard) {
        if (perLoaderRegistries != null) {
            if (key == null) {
                key = Thread.currentThread().getContextClassLoader();
            }
            if (key != null) {
                Registry localRegistry = perLoaderRegistries.get(key);
                if (localRegistry == null) {
                    localRegistry = new Registry();
                    localRegistry.guard = guard;
                    perLoaderRegistries.put(key, localRegistry);
                    return localRegistry;
                }
                if (localRegistry.guard != null && localRegistry.guard != guard) {
                    return null;
                }
                return localRegistry;
            }
        }
        if (registry == null) {
            registry = new Registry();
        }
        if (Registry.registry.guard != null && Registry.registry.guard != guard) {
            return null;
        }
        return registry;
    }

    public static void setUseContextClassLoader(boolean enable) {
        if (enable) {
            perLoaderRegistries = new HashMap();
        }
    }

    @Override
    public void stop() {
        this.descriptorsByClass = new HashMap();
        this.descriptors = new HashMap();
        this.searchedPaths = new HashMap();
    }

    @Override
    public List<ObjectName> loadMBeans(Object source, ClassLoader cl) throws Exception {
        return this.load("MbeansSource", source, null);
    }

    @Override
    public void loadMetadata(Object source) throws Exception {
        this.loadDescriptors(null, source, null);
    }

    @Override
    public void registerComponent(Object bean, String oname, String type) throws Exception {
        this.registerComponent(bean, new ObjectName(oname), type);
    }

    @Override
    public void unregisterComponent(String oname) {
        try {
            this.unregisterComponent(new ObjectName(oname));
        }
        catch (MalformedObjectNameException e) {
            log.info((Object)("Error creating object name " + e));
        }
    }

    @Override
    public void invoke(List<ObjectName> mbeans, String operation, boolean failFirst) throws Exception {
        if (mbeans == null) {
            return;
        }
        for (ObjectName current : mbeans) {
            try {
                if (current == null || this.getMethodInfo(current, operation) == null) continue;
                this.getMBeanServer().invoke(current, operation, new Object[0], new String[0]);
            }
            catch (Exception t) {
                if (failFirst) {
                    throw t;
                }
                log.info((Object)("Error initializing " + current + " " + t.toString()));
            }
        }
    }

    @Override
    public synchronized int getId(String domain, String name) {
        Integer i;
        Hashtable<String, Integer> domainTable;
        if (domain == null) {
            domain = "";
        }
        if ((domainTable = this.idDomains.get(domain)) == null) {
            domainTable = new Hashtable();
            this.idDomains.put(domain, domainTable);
        }
        if (name == null) {
            name = "";
        }
        if ((i = domainTable.get(name)) != null) {
            return i;
        }
        int[] id = this.ids.get(domain);
        if (id == null) {
            id = new int[1];
            this.ids.put(domain, id);
        }
        int n = id[0];
        id[0] = n + 1;
        int code = n;
        domainTable.put(name, code);
        return code;
    }

    public void addManagedBean(ManagedBean bean) {
        this.descriptors.put(bean.getName(), bean);
        if (bean.getType() != null) {
            this.descriptorsByClass.put(bean.getType(), bean);
        }
    }

    public ManagedBean findManagedBean(String name) {
        ManagedBean mb = this.descriptors.get(name);
        if (mb == null) {
            mb = this.descriptorsByClass.get(name);
        }
        return mb;
    }

    public String[] findManagedBeans() {
        return this.descriptors.keySet().toArray(new String[0]);
    }

    public String[] findManagedBeans(String group) {
        ArrayList<String> results = new ArrayList<String>();
        for (ManagedBean item : this.descriptors.values()) {
            if (group == null) {
                if (item.getGroup() != null) continue;
                results.add(item.getName());
                continue;
            }
            if (!group.equals(item.getGroup())) continue;
            results.add(item.getName());
        }
        String[] values = new String[results.size()];
        return results.toArray(values);
    }

    public void removeManagedBean(ManagedBean bean) {
        this.descriptors.remove(bean.getName());
        this.descriptorsByClass.remove(bean.getType());
    }

    public String getType(ObjectName oname, String attName) {
        String type = null;
        MBeanInfo info = null;
        try {
            info = this.server.getMBeanInfo(oname);
        }
        catch (Exception e) {
            log.info((Object)("Can't find metadata for object" + oname));
            return null;
        }
        MBeanAttributeInfo[] attInfo = info.getAttributes();
        for (int i = 0; i < attInfo.length; ++i) {
            if (!attName.equals(attInfo[i].getName())) continue;
            type = attInfo[i].getType();
            return type;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName oname, String opName) {
        MBeanInfo info = null;
        try {
            info = this.server.getMBeanInfo(oname);
        }
        catch (Exception e) {
            log.info((Object)("Can't find metadata " + oname));
            return null;
        }
        MBeanOperationInfo[] attInfo = info.getOperations();
        for (int i = 0; i < attInfo.length; ++i) {
            if (!opName.equals(attInfo[i].getName())) continue;
            return attInfo[i];
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName oname, String opName, int argCount) throws InstanceNotFoundException {
        MBeanInfo info = null;
        try {
            info = this.getMBeanServer().getMBeanInfo(oname);
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("registry.noMetadata", new Object[]{oname}), (Throwable)e);
            return null;
        }
        MBeanOperationInfo[] attInfo = info.getOperations();
        for (int i = 0; i < attInfo.length; ++i) {
            if (!opName.equals(attInfo[i].getName()) || argCount != attInfo[i].getSignature().length) continue;
            return attInfo[i];
        }
        return null;
    }

    public void unregisterComponent(ObjectName oname) {
        try {
            if (oname != null && this.getMBeanServer().isRegistered(oname)) {
                this.getMBeanServer().unregisterMBean(oname);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error unregistering mbean", t);
        }
    }

    public synchronized MBeanServer getMBeanServer() {
        long t1 = System.currentTimeMillis();
        if (this.server == null) {
            if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
                this.server = MBeanServerFactory.findMBeanServer(null).get(0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using existing MBeanServer " + (System.currentTimeMillis() - t1)));
                }
            } else {
                this.server = ManagementFactory.getPlatformMBeanServer();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating MBeanServer" + (System.currentTimeMillis() - t1)));
                }
            }
        }
        return this.server;
    }

    public ManagedBean findManagedBean(Object bean, Class<?> beanClass, String type) throws Exception {
        ManagedBean managed;
        if (bean != null && beanClass == null) {
            beanClass = bean.getClass();
        }
        if (type == null) {
            type = beanClass.getName();
        }
        if ((managed = this.findManagedBean(type)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Looking for descriptor ");
            }
            this.findDescriptor(beanClass, type);
            managed = this.findManagedBean(type);
        }
        if (managed == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Introspecting ");
            }
            this.load("MbeansDescriptorsIntrospectionSource", beanClass, type);
            managed = this.findManagedBean(type);
            if (managed == null) {
                log.warn((Object)("No metadata found for " + type));
                return null;
            }
            managed.setName(type);
            this.addManagedBean(managed);
        }
        return managed;
    }

    public Object convertValue(String type, String value) {
        Object objValue = value;
        if (type == null || "java.lang.String".equals(type)) {
            objValue = value;
        } else if ("javax.management.ObjectName".equals(type) || "ObjectName".equals(type)) {
            try {
                objValue = new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                return null;
            }
        } else if ("java.lang.Integer".equals(type) || "int".equals(type)) {
            objValue = Integer.valueOf(value);
        } else if ("java.lang.Long".equals(type) || "long".equals(type)) {
            objValue = Long.valueOf(value);
        } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
            objValue = Boolean.valueOf(value);
        }
        return objValue;
    }

    public List<ObjectName> load(String sourceType, Object source, String param) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("load " + source));
        }
        String location = null;
        String type = null;
        Object inputsource = null;
        if (source instanceof URL) {
            URL url = (URL)source;
            location = url.toString();
            type = param;
            inputsource = url.openStream();
            if (sourceType == null) {
                sourceType = this.sourceTypeFromExt(location);
            }
        } else if (source instanceof File) {
            location = ((File)source).getAbsolutePath();
            inputsource = new FileInputStream((File)source);
            type = param;
            if (sourceType == null) {
                sourceType = this.sourceTypeFromExt(location);
            }
        } else if (source instanceof InputStream) {
            type = param;
            inputsource = source;
        } else if (source instanceof Class) {
            location = ((Class)source).getName();
            type = param;
            inputsource = source;
            if (sourceType == null) {
                sourceType = "MbeansDescriptorsIntrospectionSource";
            }
        }
        if (sourceType == null) {
            sourceType = "MbeansDescriptorsDigesterSource";
        }
        ModelerSource ds = this.getModelerSource(sourceType);
        List<ObjectName> mbeans = ds.loadDescriptors(this, type, inputsource);
        return mbeans;
    }

    private String sourceTypeFromExt(String s) {
        if (s.endsWith(".ser")) {
            return "MbeansDescriptorsSerSource";
        }
        if (s.endsWith(".xml")) {
            return "MbeansDescriptorsDigesterSource";
        }
        return null;
    }

    public void registerComponent(Object bean, ObjectName oname, String type) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Managed= " + oname));
        }
        if (bean == null) {
            log.error((Object)("Null component " + oname));
            return;
        }
        try {
            if (type == null) {
                type = bean.getClass().getName();
            }
            ManagedBean managed = this.findManagedBean(bean.getClass(), type);
            DynamicMBean mbean = managed.createMBean(bean);
            if (this.getMBeanServer().isRegistered(oname)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unregistering existing component " + oname));
                }
                this.getMBeanServer().unregisterMBean(oname);
            }
            this.getMBeanServer().registerMBean(mbean, oname);
        }
        catch (Exception ex) {
            log.error((Object)("Error registering " + oname), (Throwable)ex);
            throw ex;
        }
    }

    public void loadDescriptors(String packageName, ClassLoader classLoader) {
        String res = packageName.replace('.', '/');
        if (log.isTraceEnabled()) {
            log.trace((Object)("Finding descriptor " + res));
        }
        if (this.searchedPaths.get(packageName) != null) {
            return;
        }
        String descriptors = res + "/mbeans-descriptors.ser";
        URL dURL = classLoader.getResource(descriptors);
        if (dURL == null) {
            descriptors = res + "/mbeans-descriptors.xml";
            dURL = classLoader.getResource(descriptors);
        }
        if (dURL == null) {
            return;
        }
        log.debug((Object)("Found " + dURL));
        this.searchedPaths.put(packageName, dURL);
        try {
            if (descriptors.endsWith(".xml")) {
                this.loadDescriptors("MbeansDescriptorsDigesterSource", dURL, null);
            } else {
                this.loadDescriptors("MbeansDescriptorsSerSource", dURL, null);
            }
            return;
        }
        catch (Exception ex) {
            log.error((Object)("Error loading " + dURL));
            return;
        }
    }

    private void loadDescriptors(String sourceType, Object source, String param) throws Exception {
        this.load(sourceType, source, param);
    }

    private void findDescriptor(Class<?> beanClass, String type) {
        String className;
        if (type == null) {
            type = beanClass.getName();
        }
        ClassLoader classLoader = null;
        if (beanClass != null) {
            classLoader = beanClass.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String pkg = className = type;
        while (pkg.indexOf(".") > 0) {
            int lastComp = pkg.lastIndexOf(".");
            if (lastComp <= 0) {
                return;
            }
            if (this.searchedPaths.get(pkg = pkg.substring(0, lastComp)) != null) {
                return;
            }
            this.loadDescriptors(pkg, classLoader);
        }
    }

    private ModelerSource getModelerSource(String type) throws Exception {
        if (type == null) {
            type = "MbeansDescriptorsDigesterSource";
        }
        if (!type.contains(".")) {
            type = "org.apache.tomcat.util.modeler.modules." + type;
        }
        Class<?> c = Class.forName(type);
        ModelerSource ds = (ModelerSource)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        return ds;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Deprecated
    public ManagedBean findManagedBean(Class<?> beanClass, String type) throws Exception {
        return this.findManagedBean(null, beanClass, type);
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public void resetMetadata() {
        this.stop();
    }
}

